<?php // Theme Options Managment

function royal_add_vika_options() {

	// Add page to submenu
	add_submenu_page(
		'themes.php',
		'Vika Options',
		'<span class="dashicons dashicons-admin-generic" style="font-size: 14px;"></span> Vika Options',
		'manage_options',
		'vika-options',
		'royal_vika_options'
	);

} // end royal_add_vika_options
add_action( 'admin_menu', 'royal_add_vika_options' );

// Sections, Settings, and Fields
function royal_initialize_vika_options() {

	// Add Section
	add_settings_section(
		'faster_managment',
		'',
		'',
		'vika-options'
	);

	// --------------------------------------

	// Add settings - body
	add_settings_field(
		'section_body',
		'Body',
		'royal_section_body_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - body
	register_setting(
		'faster_managment',
		'section_body',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - sidebar
	add_settings_field(
		'section_sidebar',
		'Sidebar',
		'royal_section_sidebar_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - sidebar
	register_setting(
		'faster_managment',
		'section_sidebar',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - logo
	add_settings_field(
		'section_logo',
		'Logo & Tagline',
		'royal_section_logo_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - logo
	register_setting(
		'faster_managment',
		'section_logo',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - menu
	add_settings_field(
		'section_menu',
		'Menu & Filters',
		'royal_section_menu_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - menu
	register_setting(
		'faster_managment',
		'section_menu',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - folio_page
	add_settings_field(
		'section_folio_page',
		'Portfolio Page',
		'royal_section_folio_page_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - folio_page
	register_setting(
		'faster_managment',
		'section_folio_page',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - portfolio_single
	add_settings_field(
		'section_portfolio_single',
		'Portfolio Single',
		'royal_section_portfolio_single_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - portfolio_single
	register_setting(
		'faster_managment',
		'section_portfolio_single',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - shop_page
	add_settings_field(
		'section_shop_page',
		'Portfolio Page',
		'royal_section_shop_page_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - shop_page
	register_setting(
		'faster_managment',
		'section_shop_page',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - shop_single
	add_settings_field(
		'section_shop_single',
		'Portfolio Single',
		'royal_section_shop_single_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - shop_single
	register_setting(
		'faster_managment',
		'section_shop_single',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - blog_page
	add_settings_field(
		'section_blog_page',
		'Blog Page',
		'royal_section_blog_page_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - blog_page
	register_setting(
		'faster_managment',
		'section_blog_page',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - blog_single
	add_settings_field(
		'section_blog_single',
		'Blog Single',
		'royal_section_blog_single_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - blog_single
	register_setting(
		'faster_managment',
		'section_blog_single',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - gallery
	add_settings_field(
		'section_gallery',
		'Gallery',
		'royal_section_gallery_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - gallery
	register_setting(
		'faster_managment',
		'section_gallery',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - similar_posts
	add_settings_field(
		'section_similar_posts',
		'Similar Posts',
		'royal_section_similar_posts_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - similar_posts
	register_setting(
		'faster_managment',
		'section_similar_posts',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - comments
	add_settings_field(
		'section_comments',
		'Comments',
		'royal_section_comments_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - comments
	register_setting(
		'faster_managment',
		'section_comments',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - inputs
	add_settings_field(
		'section_inputs',
		'Inputs',
		'royal_section_inputs_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - inputs
	register_setting(
		'faster_managment',
		'section_inputs',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - pagination
	add_settings_field(
		'section_pagination',
		'Pagination',
		'royal_section_pagination_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - pagination
	register_setting(
		'faster_managment',
		'section_pagination',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - contact_page
	add_settings_field(
		'section_contact_page',
		'Contact Page',
		'royal_section_contact_page_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - contact_page
	register_setting(
		'faster_managment',
		'section_contact_page',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - 404_page
	add_settings_field(
		'section_404_page',
		'404 Page',
		'royal_section_404_page_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - 404_page
	register_setting(
		'faster_managment',
		'section_404_page',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - copy_and_socials
	add_settings_field(
		'section_copy_and_socials',
		'Social Copyright',
		'royal_section_copy_and_socials_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - copy_and_socials
	register_setting(
		'faster_managment',
		'section_copy_and_socials',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - typography
	add_settings_field(
		'section_typography',
		'Typography',
		'royal_section_typography_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - typography
	register_setting(
		'faster_managment',
		'section_typography',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - custom_css
	add_settings_field(
		'section_custom_css',
		'Custom CSS',
		'royal_section_custom_css_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - custom_css
	register_setting(
		'faster_managment',
		'section_custom_css',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - custom_js
	add_settings_field(
		'section_custom_js',
		'Custom JS',
		'royal_section_custom_js_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - custom_js
	register_setting(
		'faster_managment',
		'section_custom_js',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - preloaders
	add_settings_field(
		'section_preloaders',
		'Preloaders',
		'royal_section_preloaders_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - preloaders
	register_setting(
		'faster_managment',
		'section_preloaders',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - sidebar_widgets
	add_settings_field(
		'section_sidebar_widgets',
		'Sidebar Widgets',
		'royal_section_sidebar_widgets_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - sidebar_widgets
	register_setting(
		'faster_managment',
		'section_sidebar_widgets',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - footer_widgets
	add_settings_field(
		'section_footer_widgets',
		'Top & Footer Widgets',
		'royal_section_footer_widgets_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - footer_widgets
	register_setting(
		'faster_managment',
		'section_footer_widgets',
		'royal_sanitize_vika_options'
	);

	// -

	// Add settings - shop_widgets
	add_settings_field(
		'section_shop_widgets',
		'Top & Footer Widgets',
		'royal_section_shop_widgets_display',
		'vika-options',
		'faster_managment'
	);
	
	// Register settings - shop_widgets
	register_setting(
		'faster_managment',
		'section_shop_widgets',
		'royal_sanitize_vika_options'
	);


} // end royal_initialize_vika_options
add_action( 'admin_init', 'royal_initialize_vika_options' );


// Render Vika Options HTML
function royal_vika_options() {
?>
	<div class="wrap">
		<h2><?php esc_html_e( 'Vika Options', 'vika' ); ?></h2>
		
		<?php settings_errors(); ?>

		<h3><?php esc_html_e('One Click Demo Import'); ?></h3>
		<input type="button" value="Import Demo Content" class="button button-primary royal-import">

		<br><br><hr><br>

		<a href="http://wp-royal.com/vika/docs/" target="_blank"><input type="button" value="Documentation" class="button button-primary"></a>
		<a href="http://wp-royal.com/vika/support/knowledge-base/" target="_blank"><input type="button" value="Knownledge Base" class="button button-primary"></a>
		<a href="http://wp-royal.com/vika/support/forums/" target="_blank"><input type="button" value="Support Forums" class="button button-primary"></a>
		<a href="mailto:contact.wproyalflush@gmail.com?Subject=Vika%20Theme%20Help%20Needed!"><input type="button" value="Email Us" class="button button-primary"></a>
		
		<br><br><hr><br>

		<h3><?php esc_html_e('Enable/Disable Customizer Sections.'); ?></h3>
		
		<form method="post" action="options.php">
			<?php
				
				// register settings
				settings_fields( 'faster_managment' );

				// buttons
				echo '<div class="toggle-save-btns">';
					echo '<input type="hidden" value="Toggle All" class="button button-primary">';
					submit_button();
					echo '<a href="'. esc_url(admin_url('/')) .'customize.php" title="Customizer"><input type="button" value="Customize" class="button button-primary"></a>';
				echo '</div>';

				// do settings
				do_settings_sections( 'vika-options' );

				// buttons
				echo '<div class="toggle-save-btns">';
					echo '<input type="hidden" value="Toggle All" class="button button-primary">';
					submit_button();
					echo '<a href="'. esc_url(admin_url('/')) .'customize.php" title="Customizer"><input type="button" value="Customize" class="button button-primary"></a>';
				echo '</div>';
				
			?>		
		</form>
	</div><!-- /.wrap -->
<?php
} // end royal_vika_options

function royal_section_colors_display() {
}

function royal_section_body_display() {
	$customizer_section_active = ( get_option('section_body') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_body.png" alt="section">';
		echo '<input type="checkbox" name="section_body" id="section_body" value="1" '. checked( true, get_option('section_body'), false ) .'>';
	echo '</div>';
}

function royal_section_sidebar_display() {
	$customizer_section_active = ( get_option('section_sidebar') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_sidebar.png" alt="section">';
		echo '<input type="checkbox" name="section_sidebar" id="section_sidebar" value="1" '. checked( true, get_option('section_sidebar'), false ) .'>';
	echo '</div>';
}

function royal_section_logo_display() {
	$customizer_section_active = ( get_option('section_logo') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_logo.png" alt="section">';
		echo '<input type="checkbox" name="section_logo" id="section_logo" value="1" '. checked( true, get_option('section_logo'), false ) .'>';
	echo '</div>';
}

function royal_section_menu_display() {
	$customizer_section_active = ( get_option('section_menu') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_menu.png" alt="section">';
		echo '<input type="checkbox" name="section_menu" id="section_menu" value="1" '. checked( true, get_option('section_menu'), false ) .'>';
	echo '</div>';
}

function royal_section_folio_page_display() {
	$customizer_section_active = ( get_option('section_folio_page') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_folio_page.png" alt="section">';
		echo '<input type="checkbox" name="section_folio_page" id="section_folio_page" value="1" '. checked( true, get_option('section_folio_page'), false ) .'>';
	echo '</div>';
}

function royal_section_portfolio_single_display() {
	$customizer_section_active = ( get_option('section_portfolio_single') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_portfolio_single.png" alt="section">';
		echo '<input type="checkbox" name="section_portfolio_single" id="section_portfolio_single" value="1" '. checked( true, get_option('section_portfolio_single'), false ) .'>';
	echo '</div>';
}

function royal_section_shop_page_display() {
	$customizer_section_active = ( get_option('section_shop_page') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_shop_page.png" alt="section">';
		echo '<input type="checkbox" name="section_shop_page" id="section_shop_page" value="1" '. checked( true, get_option('section_shop_page'), false ) .'>';
	echo '</div>';
}

function royal_section_shop_single_display() {
	$customizer_section_active = ( get_option('section_shop_single') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_shop_single.png" alt="section">';
		echo '<input type="checkbox" name="section_shop_single" id="section_shop_single" value="1" '. checked( true, get_option('section_shop_single'), false ) .'>';
	echo '</div>';
}

function royal_section_blog_page_display() {
	$customizer_section_active = ( get_option('section_blog_page') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_blog_page.png" alt="section">';
		echo '<input type="checkbox" name="section_blog_page" id="section_blog_page" value="1" '. checked( true, get_option('section_blog_page'), false ) .'>';
	echo '</div>';
}

function royal_section_blog_single_display() {
	$customizer_section_active = ( get_option('section_blog_single') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_blog_single.png" alt="section">';
		echo '<input type="checkbox" name="section_blog_single" id="section_blog_single" value="1" '. checked( true, get_option('section_blog_single'), false ) .'>';
	echo '</div>';
}

function royal_section_gallery_display() {
	$customizer_section_active = ( get_option('section_gallery') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_gallery.png" alt="section">';
		echo '<input type="checkbox" name="section_gallery" id="section_gallery" value="1" '. checked( true, get_option('section_gallery'), false ) .'>';
	echo '</div>';
}

function royal_section_similar_posts_display() {
	$customizer_section_active = ( get_option('section_similar_posts') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_similar_posts.png" alt="section">';
		echo '<input type="checkbox" name="section_similar_posts" id="section_similar_posts" value="1" '. checked( true, get_option('section_similar_posts'), false ) .'>';
	echo '</div>';
}

function royal_section_comments_display() {
	$customizer_section_active = ( get_option('section_comments') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_comments.png" alt="section">';
		echo '<input type="checkbox" name="section_comments" id="section_comments" value="1" '. checked( true, get_option('section_comments'), false ) .'>';
	echo '</div>';
}

function royal_section_inputs_display() {
	$customizer_section_active = ( get_option('section_inputs') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_inputs.png" alt="section">';
		echo '<input type="checkbox" name="section_inputs" id="section_inputs" value="1" '. checked( true, get_option('section_inputs'), false ) .'>';
	echo '</div>';
}

function royal_section_pagination_display() {
	$customizer_section_active = ( get_option('section_pagination') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_pagination.png" alt="section">';
		echo '<input type="checkbox" name="section_pagination" id="section_pagination" value="1" '. checked( true, get_option('section_pagination'), false ) .'>';
	echo '</div>';
}

function royal_section_contact_page_display() {
	$customizer_section_active = ( get_option('section_contact_page') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_contact_page.png" alt="section">';
		echo '<input type="checkbox" name="section_contact_page" id="section_contact_page" value="1" '. checked( true, get_option('section_contact_page'), false ) .'>';
	echo '</div>';
}

function royal_section_404_page_display() {
	$customizer_section_active = ( get_option('section_404_page') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_404_page.png" alt="section">';
		echo '<input type="checkbox" name="section_404_page" id="section_404_page" value="1" '. checked( true, get_option('section_404_page'), false ) .'>';
	echo '</div>';
}

function royal_section_copy_and_socials_display() {
	$customizer_section_active = ( get_option('section_copy_and_socials') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_copy_and_socials.png" alt="section">';
		echo '<input type="checkbox" name="section_copy_and_socials" id="section_copy_and_socials" value="1" '. checked( true, get_option('section_copy_and_socials'), false ) .'>';
	echo '</div>';
}

function royal_section_typography_display() {
	$customizer_section_active = ( get_option('section_typography') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_typography.png" alt="section">';
		echo '<input type="checkbox" name="section_typography" id="section_typography" value="1" '. checked( true, get_option('section_typography'), false ) .'>';
	echo '</div>';
}

function royal_section_custom_css_display() {
	$customizer_section_active = ( get_option('section_custom_css') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_custom_css.png" alt="section">';
		echo '<input type="checkbox" name="section_custom_css" id="section_custom_css" value="1" '. checked( true, get_option('section_custom_css'), false ) .'>';
	echo '</div>';
}

function royal_section_custom_js_display() {
	$customizer_section_active = ( get_option('section_custom_js') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_custom_js.png" alt="section">';
		echo '<input type="checkbox" name="section_custom_js" id="section_custom_js" value="1" '. checked( true, get_option('section_custom_js'), false ) .'>';
	echo '</div>';
}

function royal_section_preloaders_display() {
	$customizer_section_active = ( get_option('section_preloaders') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_preloaders.png" alt="section">';
		echo '<input type="checkbox" name="section_preloaders" id="section_preloaders" value="1" '. checked( true, get_option('section_preloaders'), false ) .'>';
	echo '</div>';
}

function royal_section_sidebar_widgets_display() {
	$customizer_section_active = ( get_option('section_sidebar_widgets') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_sidebar_widgets.png" alt="section">';
		echo '<input type="checkbox" name="section_sidebar_widgets" id="section_sidebar_widgets" value="1" '. checked( true, get_option('section_sidebar_widgets'), false ) .'>';
	echo '</div>';
}

function royal_section_footer_widgets_display() {
	$customizer_section_active = ( get_option('section_footer_widgets') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_footer_widgets.png" alt="section">';
		echo '<input type="checkbox" name="section_footer_widgets" id="section_footer_widgets" value="1" '. checked( true, get_option('section_footer_widgets'), false ) .'>';
	echo '</div>';
}

function royal_section_shop_widgets_display() {
	$customizer_section_active = ( get_option('section_shop_widgets') !== '' ) ? 'customizer-section-active' : '';
	echo '<div class="customizer-section '. esc_attr($customizer_section_active) .'">';
		echo '<img src="'. plugin_dir_url(__FILE__) .'images/section_shop_widgets.png" alt="section">';
		echo '<input type="checkbox" name="section_shop_widgets" id="section_shop_widgets" value="1" '. checked( true, get_option('section_shop_widgets'), false ) .'>';
	echo '</div>';
}

// sanitize values
function royal_sanitize_vika_options( $options ) { 
	return $options;
}

// enqueue ui css/js
function royal_enqueue_vika_options_scripts($hook) {

    if ( 'appearance_page_vika-options' != $hook ) {
        return;
    }

    // enqueue css
	wp_register_style( 'vika-options-ui', plugin_dir_url(__FILE__) .'/css/vika-options-ui.css' );
    wp_enqueue_style( 'vika-options-ui' );

    // enqueue js
    wp_register_script( 'vika-options-ui', plugin_dir_url(__FILE__) .'/js/vika-options-ui.js', array(), false, true );
    wp_enqueue_script( 'vika-options-ui' );

}

add_action( 'admin_enqueue_scripts', 'royal_enqueue_vika_options_scripts' );