jQuery(document).ready(function($) {
    "use strict";

/*
***************************************************************
* Demo Data Import
***************************************************************
*/

    $('.royal-import').on('click', function() {

        var currentBTN = $(this);

        if ( ! confirm('Are you sure you want to Import Vika Theme Demo Content?\n\nNOTE!\nTo make a full Demo Import you will need to install/activate following plugins: Vika Core, Visual Composer, Ultimate Addons for VC and Slider Revolution.\n\nRECOMENDED!\nMake this action on the fresh installation of Wordpress. In the other case this will affect on your current website content.') ) {
            return;
        }

        if ( $('.import-message').length === 0 ) {
            $(this).after('<br><br><div class="updated import-message"></div>');
        }

        $('.import-message').html('<p><span class="dashicons dashicons-update rf-spin"></span>&nbsp;&nbsp;Importing Demo Content... Please be patient while content is being imported! It may take several minutes.</p>');
        $('.import-message').css('border-color', '#ffba00');
        currentBTN.val('Importing Demo Cntent ...');
        $(window).scrollTop(0);

        var data = {
            action: 'royal_import'
        };

        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'royal_import'
            },
            success: function(data, textStatus, XMLHttpRequest){
                $('.import-message').html('<p><span class="dashicons dashicons-yes"></span>&nbsp;&nbsp;Import Was Sucessfull, Have Fun!</p>');
                $('.import-message').css('border-color', '#7ad03a');
                currentBTN.val('Import Demo Content');
                $(window).scrollTop(0);
            },
            error: function(MLHttpRequest, textStatus, errorThrown){
                setTimeout(function(){
                    $('.import-message').html('<p><span class="dashicons dashicons-yes"></span>&nbsp;&nbsp;Import Was Sucessfull, Have Fun!</p>');
                    $('.import-message').css('border-color', '#7ad03a');
                    currentBTN.val('Import Demo Content');
                    $(window).scrollTop(0);                    
                }, 15000);
            }
        });

    });





/*
***************************************************************
* Toggle Sections
***************************************************************
*/

$('.toggle-save-btns > input').on('click', function() {

    $('.customizer-section input').prop( 'checked', ! $('.customizer-section input').prop('checked') );

    if ( $('.customizer-section input').prop('checked') ) {
        $('.customizer-section').addClass('customizer-section-active');
    } else {
        $('.customizer-section').removeClass('customizer-section-active');
    }
    
});

$('.customizer-section').on('click', function() {
    $(this).find('input').trigger('click');
});

$('.customizer-section input').change(function() {
    $(this).closest('div').toggleClass('customizer-section-active');
});


}); // end dom ready